; Script file for Lotus Ccmail release 6.00.00 and later
; Copyright by Henter-Joyce, Inc.
; 8/14/98, A.G.
include "ccmail.jsm"
include "ccmail.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"
include "default.jsm"

Globals
	int HasFocusChanged,
	string SelectedAttachment


Script ScriptFileName()
ScriptAndAppNames ("Lotus CCMail")
EndScript

Script SayFromField ()
if IsSameScript () then
	FocusHeaderControl (From_field)
else
	ReadHeaderControl (from_field)
EndIf
EndScript

Script SaySubjectField ()
if IsSameScript () then
	FocusHeaderControl (subject_field)
else
	ReadHeaderControl (subject_field)
Endif
EndScript

Script OpenSubjectDialog ()
FocusHeaderControl (subject_button)
EndScript

Script SayDateAndTimeField ()
ReadHeaderControl (date_field)
ReadHeaderControl (time_field)
EndScript

Script OpenAddressMessageDialog ()
FocusHeaderControl (address_button)
EndScript

Script SayToListbox ()
if IsSameScript () then
	FocusHeaderControl (to_listbox)
else
	ReadHeaderControl (to_listbox)
EndIf
EndScript

Script SayPriorityCombobox ()
if IsSameScript () then
	FocusHeaderControl (priority_combobox)
else
	ReadHeaderControl (priority_combobox)
EndIf
EndScript

Script SayReceiptCheckBox ()
if IsSameScript () then
	FocusHeaderControl (receipt_checkbox)
else
	ReadHeaderControl (receipt_checkbox)
EndIf
EndScript

; The functions and scripts below assume the following windows hierarchy:
; The main message window (class=wmMsg) has 3 child windows:
; header window (class=wmCtrlPaneDlg)
; attachments list (class=VLMPane)
; edit window (class=ccEdit)
; All the header fields (From, Subject...) are child windows of the header window
; the message edit window is a child of the edit window

HANDLE Function GetMainMessageWindow (handle WinHandle)
;wc1 = "wmMsg"
while (WinHandle
	&& (GetWindowClass (WinHandle) != wc1))
	let WinHandle = GetParent (WinHandle)
EndWhile
return WinHandle
EndFunction

Int Function ReadPrompt (int ControlId, handle WinHandle)
if ToggleRestriction () then
	ToggleRestriction ()
EndIf
if (ControlId == from_field) then
	SaveCursor ()
	if (IsNewMessage () || IsDraftMessage ()) then
		InvisibleCursor ()
		MoveToControl (GetParent (WinHandle), to_combobox)
	else 
		PriorWord ()
	EndIf
	SayField ()
	restoreCursor ()
	return true
EndIf
if (ControlId == subject_field) then
	SayToCursor ()
	return true
EndIf
EndFunction

Int Function ReadHeaderControl (int ControlId)
var
	handle WinHandle
let WinHandle = GetMainMessageWindow (GetFocus ())
if (WinHandle) then
	let WinHandle = GetFirstChild (WinHandle)
	let WinHandle = GetFirstChild (WinHandle)
	While (WinHandle 
		&& (GetControlId (WinHandle) != ControlId))
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	if (winHandle) then
		SaveCursor ()
		InvisibleCursor ()
		MoveToWindow  (WinHandle)
		ReadPrompt (controlId, WinHandle)
		SayWindow (WinHandle, read_everything)
	else
		Say (msgcc1, OT_MESSAGE) ; "You must open a message to read its header information"
	EndIf
else
	Say (msgcc2, OT_MESSAGE) ; "You must open a message to read its header information"
EndIf
EndFunction

Void Function FocusHeaderControl (int ControlId)
var
	handle WinHandle
let WinHandle = GetMainMessageWindow (GetFocus ())
if (WinHandle) then
	let WinHandle = GetFirstChild (WinHandle)
	let WinHandle = GetFirstChild (WinHandle)
	While (WinHandle 
		&& (GetControlId (WinHandle) != ControlId))
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	if (winHandle) then
		JawsCursor ()
		MoveToWindow  (WinHandle)
		LeftMouseButton ()
		PCCursor ()
	else
		Say (msgcc1, OT_MESSAGE) ; field not found",
	EndIf
else
	Say (msgcc2, OT_MESSAGE) ; "You must open a message to read its header information"
EndIf
EndFunction

Script GoToMessageField ()
var
	handle WinHandle
let WinHandle = GetMainMessageWindow (GetFocus ())
if (WinHandle) then
	let WinHandle = GetFirstChild (WinHandle)
	;wc2 = "ccEdit"
	while (WinHandle 
		&& (GetWindowClass (WinHandle) != wc2))
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	if (WinHandle) then
		let WinHandle = GetFirstChild (WinHandle)
		While (WinHandle 
			&& (GetControlId (WinHandle) != message_field))
			let WinHandle = GetNextWindow (WinHandle)
		EndWhile
		if (winHandle) then
			JawsCursor ()
			MoveToWindow  (WinHandle)
			LeftMouseButton ()
			PCCursor ()
		else
			Say (msgcc3, OT_MESSAGE) ; "Message edit field not found"
		EndIf
	EndIf
else
	Say (msgcc4, OT_MESSAGE) ; "You must open a message to go to the message edit field"
EndIf
EndScript

Script GoToAttachmentList ()
var
	handle WinHandle
let WinHandle = GetMainMessageWindow (GetFocus ())
if (WinHandle) then
	let WinHandle = GetFirstChild (WinHandle)
	;wc3 = "VLMPane"
	while (WinHandle 
		&& (GetWindowClass (WinHandle) != wc3))
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	if (WinHandle) then
		JawsCursor ()
		MoveToWindow (WinHandle)
		LeftMouseButton ()
		MoveToWindow (GetAppMainWindow (WinHandle))
		RefreshWindow (WinHandle)
		PCCursor ()
	EndIf
else
	Say (msgcc5, OT_MESSAGE) ; "You must open a message to go to the attachments listbox"
EndIf
EndScript

Int Function IsNewMessage ()
;msgcc42 = 
return StringContains (GetWindowName (GetMainMessageWindow (GetFocus ())), msgcc42)
EndFunction

Int Function IsDraftMessage ()
;msgcc43 = "Draft Message "
return StringContains (GetWindowName (GetMainMessageWindow (GetFocus ())), msgcc43)
EndFunction

Script ReadMisSpelledAndAlternative ()
var
	handle WinHandle
let WinHandle = GetRealWindow (GetFocus ())
;wn1 = "Spell Check"
if (GetWindowName (WinHandle) == wn1) then
	let WinHandle = GetFirstChild (WinHandle)
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (winHandle)
	SayField ()
	SpellString (GetField ())
	while (WinHandle && (GetControlId (WinHandle) != alternatives_listbox))
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	MoveToWindow (WinHandle)
	PriorLine ()
	SayLine ()
	;msgcc44 = "No Alternatives"
	if (!StringContains (GetLine (), msgcc44)) then
		NextLine ()
		SayField ()
		SpellString (GetField ())
	EndIf
else
	Say (msgcc6, OT_MESSAGE) ; "you must be in the Spell Check dialog to read the misspelled word and first alternative."
EndIf
EndScript

Script SayNumberOfOccurrencesFound ()
var
	handle WinHandle,
	string found
let WinHandle = GetFocus ()
SaveCursor ()
InvisibleCursor ()
;msgcc45 = "Found :"
if FindString (WinHandle, msgcc45, s_top, s_unrestricted) then
	NextWord ()
	if (GetControlId (GetCurrentWindow ()) == found_prompt) then
		SayChunk ()
		NextWord ()
		SayChunk ()
		return
	EndIf
EndIf
Say (msgcc7, OT_MESSAGE) ; "Number of occurrences not visible"
EndScript

Void Function SayHighlightedText (handle WinHandle, string buffer)
;msgcc46 = "JAWS find"
if (InJawsFind	&& 
	(GetWindowName (GetRealWindow (GetFocus ())) != msgcc46)) then
	return
EndIf
;wc3 = "vlmpane"
if (GetWindowClass (WinHandle) == wc3) then
	if (WinHandle != GetFocus ()) then
		return
	endIf
	if (GetMainMessageWindow (WinHandle) == GetParent (WinHandle)) then
		let SelectedAttachment = buffer
		Say (buffer, OT_BUFFER)
		return
	EndIf
EndIf
;wn1 = "spell Check"
if (GetWindowName (GetRealWindow (WinHandle)) == wn1) then
	if (GetControlId (WinHandle) == ReplaceWith_field) then
		if HasFocusChanged then
			let HasFocusChanged = false
		else
			PerformScript ReadMisSpelledAndAlternative ()
		EndIf
		return
	EndIf
EndIf
if (GetScreenEcho() > 0) Then
	Say (buffer, OT_BUFFER)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
if (TheClass == "static") then
	;msgcc47 = "Sending Message..."
	if StringContains (buffer, msgcc47) then
		Say (buffer, OT_BUFFER)
		return
	EndIf
EndIf
if ((GetScreenEcho() > 1)
   ;wn36="#32771"
   || (TheClass == wn36 )) then
	Say (buffer, OT_BUFFER)
EndIf
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
if (InJawsFind	&& 
	(GetWindowName (GetRealWindow (FocusWindow)) != msgJawsFind)) then
	return
EndIf
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if !(GetWindowClass (FocusWindow) == "sccdisplay90") then
	If ToggleRestriction () then
		ToggleRestriction ()
	EndIf
EndIf
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText(AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
;no matter what, say the window with focus
;but do it by calling a subroutine that can be special for each application, 
; for example, progman.jms
let GlobalFocusWindow = FocusWindow
SayFocusedWindow()  ; will use global variable "GlobalFocusWindow"
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SayFocusedWindow ()
var
	handle WinHandle,
	int ControlId
let WinHandle = GetRealWindow (GlobalFocusWindow)
if (GetWindowName (WinHandle) == msgSpellCheck) then
	if (GetControlId (GlobalFocusWindow) == ReplaceWith_field) then
		let HasFocusChanged = true
		PerformScript ReadMisspelledAndAlternative ()
		return
	EndIf
EndIf
let ControlId = GetControlId (GlobalFocusWindow) 
if (ControlId == from_field) then
	if (IsNewMessage () || IsDraftMessage ()) then
		ReadPrompt (from_field, GlobalFocusWindow)
	EndIf
EndIf
if (ControlId == subject_field) then
	if (GetMainMessageWindow (GlobalFocusWindow)) then
		ReadPrompt (subject_field, GlobalFocusWindow)
		Say (msgcc8, OT_MESSAGE) ; "edit"
		return
	EndIf
EndIf
if (ControlId == Priority_combobox) then
	if (GetMainMessageWindow (GlobalFocusWindow)) then
		Say (msgcc9, OT_MESSAGE); "Priority ComboBox"
		return
	EndIf
EndIf
;wc3 = "VLMPane"
if (GetWindowClass (GlobalFocusWindow) == wc3) then
	if (GetParent (GlobalFocusWindow) == GetMainMessageWindow (GlobalFocusWindow)) then
		Say (msgcc10, OT_MESSAGE) ; "Attachments list"
		return
	EndIf
EndIf
;wc4 = "sccdisplay90"
if (GetWindowClass (GlobalFocusWindow) == wc4) then
	if (GetVerbosity () == beginner) then
		Say (msgcc11, OT_MESSAGE) ; "The jaws cursor is on "
		Say (msgcc12, OT_MESSAGE) ; "and Restriction is on "
		Say (msgcc13, OT_MESSAGE) ; "Use the JAWS cursor to read this window"
	EndIf
	ReadAttachment ()
	return
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Function ReadAttachment (string LastVisibleLine)
JawsCursor ()
if (LastVisibleLine != "") then
	if FindString (GlobalFocusWindow, LastVisibleLine, s_top, s_restricted)
	&& (GetLine () == LastVisibleLine) then
		NextLine ()
	else
		MoveToWindow (GlobalFocusWindow)
	EndIf
else
	MoveToWindow (GlobalFocusWindow)
EndIf
if !ToggleRestriction () then
	ToggleRestriction ()
EndIf
SayAll ()
EndFunction

Script SayNextScreen ()
var
	string LastVisibleLine
InvisibleCursor ()
MoveToWindow (GetFocus ())
if !ToggleRestriction () then
	ToggleRestriction ()
EndIf
JawsPageDown ()
let LastVisibleLine = GetLine ()
{PageDown}
Pause ()
ReadAttachment (LastVisibleLine)
EndScript

Script SayPriorScreen ()
{PageUp} ; tell help to do page up
Pause()
ReadAttachment ("")
EndScript

Script ScreenSensitiveHelp ()
;wc4 = "sccdisplay90"
if (GetWindowClass (GetCurrentWindow ()) == wc4) then
	Say (msgcc14, OT_HELP) ; "This window contains the text of an attached file "
	Say (msgcc15, OT_HELP) ; "Use the Jaws cursor to read it "
	Say (msgcc16, OT_HELP) ; "To select text you may lock the left mouse button and use the standard movement keys "
	return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

Script HotKeyHelp ()
var
	handle WinHandle
let WinHandle = GetFocus ()
if (GetMainMessageWindow (WinHandle)) then
	;wc4 = "sccdisplay90"
	if (GetWindowClass (GetCurrentWindow ()) == wc4) then
		; msgcc17 = "to scroll down one page and reed with the JAWS cursor use "
		Say (msgcc17 + GetScriptKeyName ("SayNextScreen"), OT_HELP) 
		; msgcc18 = "to scroll up one page and reed with the JAWS cursor use " 
		Say (msgcc18 + GetScriptKeyName ("SayPriorScreen"), OT_HELP)
	EndIf
	Say (msgcc19, OT_HELP) ; "When reading or writing a message "
	Say (msgcc20, OT_HELP) ; "you may use the following hotKeys:"
	Say (msgcc21, OT_HELP) ; "To read the message header information "
	Say (msgcc22, OT_HELP) ; "use Alt + numbers 1 through 6."
	Say (msgcc23, OT_HELP) ; "Press twice quickly to edit the corresponding field."
	Say (msgcc24, OT_HELP) ; "To go to the message edit window from any header field "
	Say (msgcc25 + GetScriptKeyName ("GoToMessageField"), OT_HELP) ; "use alt + `."
	Say (msgcc26, OT_HELP) ; "To go to the attachments listbox "
	Say (msgcc27 + GetScriptKeyName ("GoToAttachmentList"), OT_HELP) ; "use Insert + eigh. "
	Say (msgcc28, OT_HELP) ; "To open the Address Message dialog "
	Say (msgcc29+ GetScriptKeyName ("OpenAddressMessageDialog"), OT_HELP) ; "use Alt + shift + 1"
	Say (msgcc30, OT_HELP) ; "To open the subject dialog "
	Say (msgcc31 + GetScriptKeyName ("OpenSubjectDialog"), OT_HELP) ; "use Alt + Shift + 4."
	return
EndIf
SaveCursor ()
InvisibleCursor ()
;msgcc45 = "Found :"
if FindString (WinHandle, msgcc45, s_top, s_unrestricted) then
	NextWord ()
	if (GetControlId (GetCurrentWindow ()) == found_prompt) then
		Say (msgcc32, OT_HELP) ; "To read the number of occurrences found in the search dialog "
		Say (msgcc33+ GetScriptKeyName ("SayNumberOfOccurrencesFound"), OT_HELP)
	EndIf
EndIf
let WinHandle = GetRealWindow (WinHandle)
;wn1 = "Spell Check"
if (GetWindowName (WinHandle) == wn1) then
	Say (msgcc34, OT_HELP) ; "to here the misspelled word and the first alternative "
	Say (msgcc35 + GetScriptKeyName ("ReadMisSpelledAndAlternative"), OT_HELP) ; "use Control + Insert + E."
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script SayPriorLine () 
var
	handle WinHandle,
	int TheTypeCode
PriorLine()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
endif
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if not IsPCCursor() then
	SayLine()
	return
endif
let WinHandle = GetFocus ()
;wc3 = "VLMPane"
if (GetWindowClass (WinHandle) == wc3) then
	if (GetParent (WinHandle) == GetMainMessageWindow (WinHandle)) then
		RefreshWindow (WinHandle)
		return
	EndIf
	if IsMessageUnread () then
		Say (msgcc41, OT_HELP) ; "Unread message"
	EndIf
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
endif
if CaretVisible() then
	SayLine()
	return
endif
if ((TheTypeCode == WT_TREEVIEW) ||
	(TheTypeCode == WT_LISTBOX) ||
	(TheTypeCode == WT_MULTISELECT_LISTBOX) ||
	(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayNextLine() 
var
	handle WinHandle,
	int TheTypeCode
NextLine()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
endif
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if  not IsPCCursor() then
	SayLine()
	return
endif
let WinHandle = GetFocus ()
;wc3 = "VLMPane"
if (GetWindowClass (WinHandle) == wc3) then
	if (GetParent (WinHandle) == GetMainMessageWindow (WinHandle)) then
		RefreshWindow (WinHandle)
		return
	EndIf
	if IsMessageUnread () then
		Say (msgcc41, OT_HELP) ; "Unread message"
	EndIf
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
endif
if CaretVisible() then
	SayLine()
	return
endif
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_LISTBOX) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayLine ()
var
	handle WinHandle
let WinHandle = GetFocus ()
;wc3 = "vlmpane"
if (GetWindowClass (WinHandle) == wc3) then
	if (GetMainMessageWindow (WinHandle) == GetParent (WinHandle)) then
		Say (SelectedAttachment, OT_BUFFER)
		return
	EndIf
	if IsMessageUnread () then
		Say (msgcc41, OT_HELP) ; "Unread message"
	EndIf
EndIf
SayLine ()
EndScript

Script SayWord ()
var
	handle WinHandle
if (IsPCCursor ()) then
let WinHandle = GetFocus ()
;wc3 = "vlmpane"
if (GetWindowClass (WinHandle) == wc3) then
	if (GetMainMessageWindow (WinHandle) == GetParent (WinHandle)) then
		Say (SelectedAttachment, OT_BUFFER)
		return
	EndIf
EndIf
EndIf
PerformScript SayWord ()
EndScript

Script SayCharacter ()
var
	handle WinHandle
if (IsPCCursor ()) then
let WinHandle = GetFocus ()
;wc3 = "vlmpane"
if (GetWindowClass (WinHandle) == wc3) then
	if (GetMainMessageWindow (WinHandle) == GetParent (WinHandle)) then
		Say (SubString (SelectedAttachment, 1, 1), OT_BUFFER)
		return
	EndIf
EndIf
EndIf
PerformScript SayCharacter()
EndScript

HANDLE Function GetRealWindow (handle WinHandle)
if GetMainMessageWindow (winHandle) then
	return GetMainMessageWindow (WinHandle)
EndIf
return GetRealWindow (WinHandle)
EndFunction

String Function GetHotKey ()
var
	handle WinHandle,
	int ControlId
let WinHandle = GetCurrentWindow ()
;wn2 = "User setup"
if (GetWindowName (GetRealWindow (WinHandle)) == wn2) then
	let ControlId = GetControlId (WinHandle)
	if (ControlId == LowPriority_RadioButton) then
		return msgcc36 ; "w"
	EndIf
	if (ControlId == exit_checkbox) then
		return msgcc37 ; "e"
	EndIf
EndIf
return GetHotKey ()
EndFunction

String Function GetChunk ()
var
	handle WinHandle,
	int ControlId
let WinHandle = GetCurrentWindow ()
;wn2 = "User setup"
if (GetWindowName (GetRealWindow (WinHandle)) == wn2) then
	let ControlId = GetControlId (WinHandle)
	if (ControlId == LowPriority_RadioButton) then
		return msgcc38 ; "Low"
	EndIf
	if (ControlId == exit_checkbox) then
		return msgcc39 ; "Confirm to Exit cc:mail"
	EndIf
EndIf
return GetChunk ()
EndFunction

Script PassAltDeleteThrough ()
{Alt + Delete}
Say (msgcc40, OT_MESSAGE) ; "Alt Delete"
EndScript

Void Function IsMessageUnread ()
var
	handle WinHandle,
	string BackGroundColor,
	string TextColor
let WinHandle = GetCurrentWindow ()
;wc3 = "VLMPane"
if (GetWindowClass (WinHandle) == wc3) then
	if !GlobalMenuMode then
		let BackGroundColor = ColorToRGBString (GetColorBackground ())
		let TextColor = ColorToRGBString (GetColorText ())
		if ((BackGroundColor == "000000128") && (TextColor == "255255255")) then
			return true
		EndIf
	EndIf
EndIf
return false
EndFunction

Function AutoFinishEvent ()
If ToggleRestriction () then
	ToggleRestriction ()
EndIf
EndFunction
